function x = J1ZZTproduct( v, mode, J1prod, J2TDprod, n, m2 )

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%matlab%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File             :  J1ZZTproduct.m
% Description      :  Computation of J1*Z*Z'*v (= J1*v in our special case) 
%                     or Z*Z'*J1'*v for given vectors v whenever LSQR 
%                     needs these products. 
% Author           :  Inga Schierle
% email            :  inga.schierle@gmx.de
% Created on       :  May 28, 2007
% Last modified by :  Michael Saunders
% Last modified on :  24 Dec 2010
% Update count     :  1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Date          Name         Changes / Extensions
% ----          ----         --------------------
% 24 Dec 2010   MAS          Reversed v and mode parameters.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%--------------------------------------------------------------------------
%  [x, vz] = J1ZZTproduct( v, mode, J1prod, J2TDprod, n, m2 )
%
%  if mode = 1, J1ZZTproduct computes y = J1*v (= J1*Z*Z'*v)
%  if mode = 2, J1ZZTproduct computes y = Z*Z'*J1'*v
%  for some matrix (J1*Z*Z').
%--------------------------------------------------------------------------

atol2   = 1e-14;
btol2   = atol2;
conlim2 = 1e+8;
itnlim2 = 50000;
show2   = 0;
damp2   = 0;


if mode==1 
    x = J1prod(v,1); 
else
    b = J1prod(v,2);
%     J2b = J2 * b;
%     sol = J2J2T\J2b;
%     x   = b - J2'*sol;
    sol = covlsqr( n, m2, J2TDprod, b, damp2, atol2, btol2, conlim2, itnlim2, show2, 0 );
    x   = b - J2TDprod(sol,1);      
end

%--------------------------------------------------------------------------
% End of J1ZZTproduct.m
%--------------------------------------------------------------------------
