function y = aprod(v,mode,A)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%matlab%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File             :  aprod.m
% Description      :  Computation of A*v or A'*v. 
% Author           :  Inga Schierle
% email            :  inga.schierle@gmx.de
% Created on       :  May 28, 2007
% Last modified by :  Michael Saunders
% Last modified on :  24 Dec 2010
% Update count     :  1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Date          Name         Changes / Extensions
% ----          ----         --------------------
% 24 Dec 2010   MAS          Reversed inputs v and mode.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%--------------------------------------------------------------------------
%  y = aprod(v,mode,A)
%
%  if mode = 1, aprod computes y = A*v
%  if mode = 2, aprod computes y = A'*v
%  for some matrix  A.
%--------------------------------------------------------------------------

if mode==1
   y = A *v;
else
   y = A'*v;
end

%--------------------------------------------------------------------------
% End of aprod.m
%--------------------------------------------------------------------------
