function x = covlsqrtest( m, n, damp )

%        x = covlsqrtest(  m, n, damp);
%        x = covlsqrtest( 10,10, 0   );
%        x = covlsqrtest( 20,10, 0   );
%        x = covlsqrtest( 20,10, 0.1 );
%
% If m = n and damp = 0, this sets up a system Ax = b
% and calls covlsqr.m to solve it.  Otherwise, the usual
% least-squares or damped least-squares problem is solved.

% 24 Dec 2010: First version of covlsqrtest.m
%              derived from lsqrSOLtest.m.

%              Michael Saunders, Systems Optimization Laboratory,
%              Dept of MS&E, Stanford University.
%-----------------------------------------------------------------------

  A      = @(v,mode) Aprodxxx( v,mode,m,n );  % Nested function

  xtrue  = (n : -1: 1)';
  b      = A(xtrue,1);

  atol   = 1.0e-6;
  btol   = 1.0e-6;
  conlim = 1.0e+10;
  itnlim = 10*n;
  show   = 1;
  IC     = [1 n];

  [ x, istop, itn, rnorm, anorm, acond, arnorm, xnorm, var, cov ]...
    = covlsqr( m, n, A, b, damp, atol, btol, conlim, itnlim, show, IC);

  disp(' ');   j1 = min(n,5);   j2 = max(n-4,1);
  disp('First elements of x:');  disp(x(1:j1)');
  disp('Last  elements of x:');  disp(x(j2:n)');

  r     = b - A(x,1);
  rtrue = [    r
           (-damp*x)];
  fprintf('\n rnorm (est.)  %10.3e', rnorm )
  fprintf('\n rnorm (true)  %10.3e', norm(rtrue) )
  fprintf('\n')

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Nested functions (only 1 here).
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  function y = Aprodxxx( x, mode, m, n )

    % Private function.
    % if mode = 1, computes y = A*x
    % if mode = 2, computes y = A'*x
    % for some matrix  A.
    %
    % This is a simple example for testing  LSQR.
    % It uses the leading m*n submatrix from
    % A = [ 1
    %       1 2
    %         2 3
    %           3 4
    %             ...
    %               n ]
    % suitably padded by zeros.
    %
    % 11 Apr 1996: First version for distribution with lsqr.m.
    %              Michael Saunders, Dept of EESOR, Stanford University.

    if mode == 1
      d  = (1:n)';  % Column vector
      y1 = [d.*x; 0] + [0;d.*x];
      if m <= n+1
	y = y1(1:m);
      else         
	y = [     y1; 
	  zeros(m-n-1,1)];
      end
    else
      d  = (1:m)';  % Column vector
      y1 = [d.*x] + [d(1:m-1).*x(2:m); 0];
      if m >= n
	y = y1(1:n);
      else
	y = [y1;
	  zeros(n-m,1)];
      end
    end

  end % nested function Aprodxxx

end % function covlsqrtest


