function [ m1, m2, n, J1, J2, f1, f2, IC ] = myset

%        [ m1, m2, n, J1, J2, f1, f2, IC ] = myset;
%  defines a fixed set of data for use by mytestQR and mytestLSQR.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%matlab%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File             :  myset.m
% Description      :  Definition of J1, J2 as random matrices
%                     (of size m1 x n, m2 x n)
%                     and f1, f2 as random vectors (of size m1, m2).
% Author           :  Inga Schierle
% email            :  inga.schierle@gmx.de
% Created on       :  May 28, 2007
% Last modified by :  Michael Saunders
% Last modified on :  24 Dec 2010
% Update count     :  1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Date          Name           Changes / Extensions
% ----          ----           --------------------
% 24 Dec 2010   MAS            Reversed outputs m1, m2.
%                              Randstream now used (newer Matlab).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%--------------------------------------------------------------------------
% Initialization of J1, J2, f1, f2.
%--------------------------------------------------------------------------

m1 = 7;
m2 = 14;
n  = 18;

% rand( 'state', 0 );                % Prior to Matlab 7.7
reset(RandStream.getDefaultStream);  %          Matlab 7.7 and later
J1 = rand( m1, n );
J2 = rand( m2, n );
f1 = rand( m1, 1 );
f2 = rand( m2, 1 );
% clear all;

IC = m2+1 : n;

%--------------------------------------------------------------------------
% End of myset.m
%--------------------------------------------------------------------------
