% mytest.m is a script that calls
%   myset.m
%   mytestQR.m
%   mytestLSQR.m
% and checks that the last two compute essentially the same
% quantities dx and cov.  It's a way of testing covLSQR.m.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%matlab%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File             :  mytest.m
% Description      :  Compare the output of mytestQR and mytestLSQR.
% Author           :  Michael Saunders
% email            :  saunders@stanford.edu
% Created on       :  24 Dec 2010
% Last modified by :  
% Last modified on :  
% Update count     :  0
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Date          Name           Changes / Extensions
% ----          ----           --------------------
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf('\n\n Comparing mytestQR and mytestLSQR\n')
fprintf('\n dx and cov from mytestQR\n')
[dx , cov ] = mytestQR
fprintf('\n dx and cov from mytestLSQR\n')
[dx2, cov2] = mytestLSQR

err1 = norm(dx-dx2,inf);
err2 = norm(cov-cov2,inf);
fprintf('\n ||dx - dx2|| = %8.1e', err1)
fprintf('\n ||cov-cov2|| = %8.1e', err2)

if err1+err2 < 1e-8
    fprintf('\n covLSQR seems to have performed correctly\n')
else
    fprintf('\n covLSQR seems to have performed INcorrectly\n')
end
