function [x2,cov2] = mytestQR

%        [x2,cov2] = mytestQR
% solves a constrained least-squares problem (defined by myset.m)
% using a direct factorization method.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%matlab%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File             :  mytestQR.m
% Description      :  Solver (based on QR factors) for a linear least 
%                     square problem with linear constraints;
%                     mytestQR.m can also compute the parameter covariance
%                     matrix for a large parameter estimation problem with
%                     nonlinear equality constraints.
% Author           :  Inga Schierle
% email            :  inga.schierle@gmx.de
% Created on       :  May 28, 2007
% Last modified by :  Michael Saunders
% Last modified on :  24 Dec 2010
% Update count     :  1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Date          Name           Changes / Extensions
% ----          ----           --------------------
% 24 Dec 2010   MAS            Minor details.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%--------------------------------------------------------------------------
% To solve
%    min 1/2 || J1*x + b1 ||^2
%    s.t.       J2*x + b2 = 0
% we solve the unconstrained problem
%    min || (J1*Z)*w - g ||^2 (= min || J1*(Z*Z')*s - g||^2)
% using QR factors.
%--------------------------------------------------------------------------

%--------------------------------------------------------------------------
% Definition of J1, J2, f1, f2, and IC.
%--------------------------------------------------------------------------
[ m1, m2, n, J1, J2, f1, f2, IC ] = myset;
n2 = n - m2;

%--------------------------------------------------------------------------
% QR factorization of J2'.
%--------------------------------------------------------------------------
[Q,R]   = qr( J2' );
Y       = Q( :, 1:m2 );
Z       = Q( :, m2+1:n );
R       = R( 1:m2, : );

%--------------------------------------------------------------------------
% Computation of g using QR factors.
%--------------------------------------------------------------------------
y1      = R'\( -f2 );
y2      = zeros( n2, 1 );
y       = [ y1; y2 ];
dx      = Q * y;
dxfirst = dx( 1:2, 1 );
g       = - f1 - J1 * dx;
gfirst  = g( 1:2, 1 );

%--------------------------------------------------------------------------
% Computation of x = Z*w + dx.
%--------------------------------------------------------------------------
A   = J1*Z;
if m1 >= n2
    w  = A \ g;
else
    [QA,RA] = qr( A' );
    YA      = QA( :, 1:m1 );
    ZA      = QA( :, m1+1:n2 );
    RA      = RA( 1:m1, : );
    yA1     = RA' \ g;
    yA2     = zeros( n2-m1, 1 );
    yA      = [ yA1; yA2 ];
    w       = QA * yA;
end

Zw   = Z * w;
x2   = Zw + dx;
cov  = Z * ( inv(A'*A) ) * Z';
cov2 = cov(IC,IC);

%--------------------------------------------------------------------------
% End of mytestQR.m
%--------------------------------------------------------------------------
