!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! File lsmrReverse_TestProgram.f90
!
!    lsmrReverse_TestProgram
!
! Main program for testing LSMR via subroutine lsmrtest in lsmrTestModule.
!
! Maintained by Michael Saunders <saunders@stanford.edu>.
!
! 16 Jul 2010: LSMR version derived from LSQR equivalent.
! 23 Nov 2015: Reverse communication version developed by
!              Nick Gould and Jennifer Scott
!              nick.gould@stfc.ac.uk, jennifer.scott@stfc.ac.uk
!              STFC Rutherford Appleton Laboratory
!              Harwell, Oxford, Didcot
!              United Kingdom OX11 0QX
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

program lsmrReverse_TestProgram

  use   lsmrReverse_TestModule, only : lsmrtest
  implicit none
  integer(4),  parameter :: ip = KIND( 1 )
  integer(4),  parameter :: dp = KIND( 1.0D+0 )


  !---------------------------------------------------------------------
  ! This program calls lsmrtest(...) to generate a series of test problems
  ! Ax = b or Ax ~= b and solve them with LSMR.
  ! The matrix A is m x n.  It is defined by routines in lsmrReverse_TestModule.
  !
  ! 23 Sep 2007: First version of lsmrTestProgram.f90.
  ! 24 Oct 2007: Use real(dp) instead of compiler option -r8.
  ! 23 Nov 2015: Reverse communication variant.
  !---------------------------------------------------------------------

  ! Local variables
  integer(ip)  :: m,n,nbar,ndamp,nduplc,npower,nout
  integer(ip)  :: localSize  ! No. of vectors involved in local reorthogonalization (>= 0)
  real(dp)     :: damp


  nout   = 6
  open(nout,file='LSMR.txt',status='unknown')



  nbar   = 100  ! 1000
  nduplc =   4  ! 40


  m = 2*nbar        ! Over-determined systems
  n = nbar
  localSize = 0

  do ndamp = 2,6
     npower = ndamp
     damp   = 0.0
     if (ndamp > 2) damp   = 10.0**(-ndamp)
     call lsmrtest(m,n,nduplc,npower,damp,localSize,nout)
  end do

  localsize = 10    ! Repeat last test with local reorthogonalization
  call lsmrtest(m,n,nduplc,npower,damp,localSize,nout)


  m = nbar          ! Square systems
  n = nbar
  localSize = 0

  do ndamp = 2,6
     npower = ndamp
     damp   = 0.0
     if (ndamp > 2) damp   = 10.0**(-ndamp-6)
     call lsmrtest(m,n,nduplc,npower,damp,localSize,nout)
  end do

  localsize = 10    ! Repeat last test with local reorthogonalization
  call lsmrtest(m,n,nduplc,npower,damp,localSize,nout)


  m = nbar          ! Under-determined systems
  n = 2*nbar
  localSize = 0

  do ndamp = 2,6
     npower = ndamp
     damp   = 0.0
     if (ndamp > 2) damp   = 10.0**(-ndamp-6)
     call lsmrtest(m,n,nduplc,npower,damp,localSize,nout)
  end do

  localsize = 10    ! Repeat last test with local reorthogonalization
  call lsmrtest(m,n,nduplc,npower,damp,localSize,nout)

  close(nout)

end program lsmrReverse_TestProgram
