/**
 * @file   IterSolver.hpp
 * @author Xiangrui Meng <mengxr@stanford.edu>
 * @date   Tue Oct  4 22:49:54 2011
 * 
 * @brief  
 * 
 * 
 */

#ifndef _ITERSOLVER_HPP
#define _ITERSOLVER_HPP

#include "Vec.hpp"
#include "LinOp.hpp"

void lsqr( LinOp<double>& A, const Vec_d b,
           const double tol, const long maxit,
           Vec_d& x );

void ls_chebyshev( LinOp<double>& A, const Vec_d b,
                   const double s_max, const double s_min,
                   const double tol, Vec_d& x );

#endif  // _ITERSOLVER_HPP
