/**
 * @file   RandSolver.hpp
 * @author Xiangrui Meng <mengxr@stanford.edu>
 * @date   Tue Oct  4 23:30:52 2011
 * 
 * @brief  
 * 
 * 
 */

#ifndef _RANDSOLVER_HPP
#define _RANDSOLVER_HPP

#include "Config.hpp"
#include "Vec.hpp"
#include "LinOp.hpp"

/** 
 * Random normal projection. Project A's columns/rows to an s-dimensional space.
 * 
 * @param A input matrix
 * @param s sample size
 * 
 * @return 
 */
Mat_d rnpj( LinOp<double>& A, ptrdiff_t s );

/** 
 * Preconditioning using random normal projection
 * 
 * @param A input matrix
 * @param s sample size
 * 
 * @return preconditioner
 */
Mat_d rnpre( LinOp<double>& A, LONG s, double rcond = 1e-12 );

void lsrn( LinOp<double>& A, Vec_d& b, double rcond, Vec_d& x, LONG& rank );

void lsne( LinOp<double>& A, Vec_d& b, double rcond, Vec_d& x, LONG& rank );

#endif  // _RANDSOLVER_HPP
