#ifndef _FBLAS_H
#define _FBLAS_H

#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif
  
  typedef ptrdiff_t blas_int;
  
#define FBLAS_WRAPPER(func) func ## _
  
#define dcopy FBLAS_WRAPPER(dcopy)
  extern void dcopy( const blas_int *n,
                     const double *dx, const blas_int *incx,
                     const double *dy, const blas_int *incy );

#define dgemv FBLAS_WRAPPER(dgemv)
  extern void dgemv( const char *trans,
                     const blas_int *m, const blas_int *n,
                     const double *alpha,
                     const double *a, const blas_int *lda,
                     const double *x, const blas_int *incx,
                     const double *beta,
                     const double *y, const blas_int *incy );

#define dgemm FBLAS_WRAPPER(dgemm)
  extern void dgemm( const char *trans_a, const char *trans_b,
                     const blas_int *m, const blas_int *n, const blas_int *k,
                     const double *alpha,
                     const double *a, const blas_int *lda,
                     const double *b, const blas_int *ldb,
                     const double *beta,
                     const double *c, const blas_int *ldc );

#define dnrm2 FBLAS_WRAPPER(dnrm2)
  extern const double dnrm2( const blas_int *n,
                             const double *x, const blas_int *incx );
  
#define dscal FBLAS_WRAPPER(dscal)
  extern void dscal( const blas_int *n,
                     const double *da,
                     const double *dx, const blas_int *incx );

#define daxpy FBLAS_WRAPPER(daxpy)
  extern void daxpy( const blas_int *n,
                     const double *da,
                     const double *dx, const blas_int *incx,
                     const double *dy, const blas_int *incy );

#ifdef __cplusplus
}
#endif
  
#endif  /* _FBLAS_H */
