#ifndef _FLAPACK_H
#define _FLAPACK_H

#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

  typedef ptrdiff_t lapack_int;
  
#define FLAPACK_WRAPPER(func) func ## _
  
#define dgesdd FLAPACK_WRAPPER(dgesdd)
  extern void dgesdd( const char* jobz, const lapack_int *m, const lapack_int *n,
                      const double* a, const lapack_int *lda,
                      const double* s,
                      const double* u, const lapack_int *ldu,
                      const double* vt, const lapack_int *ldvt,
                      const double* work, const lapack_int *lwork, const lapack_int *iwork,
                      const lapack_int *info );
  
  
#define dgelsd FLAPACK_WRAPPER(dgelsd)
  extern void dgelsd( const lapack_int *m, const lapack_int *n, const lapack_int *nrhs,
                      const double *a, const lapack_int *lda,
                      const double *b, const lapack_int *ldb,
                      const double *s, const double *rcond, const lapack_int *rank,
                      const double *work, const lapack_int *lwork, const lapack_int *iwork,
                      const lapack_int *info );
  
#define dpotrf FLAPACK_WRAPPER(dpotrf)
  extern void dpotrf( const char *uplo, const lapack_int *n,
                      const double *a, const lapack_int *lda, const lapack_int *info );

#define dpotrs FLAPACK_WRAPPER(dpotrs)
  extern void dpotrs( const char *uplo, const lapack_int *n, const lapack_int *nrhs,
                      const double *a, const lapack_int *lda,
                      const double *b, const lapack_int *ldb, const lapack_int *info );
  
#ifdef __cplusplus  
}
#endif

#endif  /* _FLAPACK_H */
