/**
 * @file   lsrn_mex.cpp
 * @author Xiangrui Meng <mengxr@stanford.edu>
 * @date   Tue Oct  4 15:41:06 2011
 * 
 * @brief  
 * 
 * 
 */

#include "mex.h"
#include "matrix.h"

#include "Vec.hpp"
#include "LinOp.hpp"
#include "LinAlg.hpp"
#include "RandSolver.hpp"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  if( nrhs < 2 || nrhs > 3 )
  {
    mexErrMsgTxt( "Two or three inputs expected." );
  }

  const mxArray * mx_A = prhs[0];
  const mxArray * mx_B = prhs[1];
  
  long m  = mxGetM( mx_A );
  long n  = mxGetN( mx_A );
  long mb = mxGetM( mx_B );
  long nb = mxGetN( mx_B );
  if( mb != m || nb != 1 )
  {
    mexErrMsgTxt( "Dimensions do not match." );
  }
  
  double rcond = 1e-12;
  if( nrhs >= 3 )
  {
    rcond = (double) mxGetScalar( prhs[2] );
  }

  Vec_d b( m, mxGetPr(mx_B) );

  plhs[0]   = mxCreateDoubleMatrix( n, 1, mxREAL );
  Vec_d x( n, mxGetPr( plhs[0] ) );

  long rank;
  
  if( mxIsSparse(mx_A) )
  {
    CSC_Mat_d A( m, n, (LONG) mxGetNzmax(mx_A),
                 (LONG *) mxGetIr(mx_A), (LONG *) mxGetJc(mx_A), (double *) mxGetPr(mx_A) );
    SpMat_Op<double> A_op(A);
    lsrn( A_op, b, rcond, x, rank );
  }
  else
  {
    Mat_d A( m, n, (double *) mxGetPr(mx_A) );
    lsrn( A, b, rcond, x, rank );
  }
  
  if( nlhs >= 2 )
    plhs[1] = mxCreateDoubleScalar( (double) rank );
}
