/**
 * @file   test_iter_solver.cpp
 * @author Xiangrui Meng <mengxr@stanford.edu>
 * @date   Wed Oct  5 00:02:26 2011
 * 
 * @brief  
 * 
 * 
 */

#include <time.h>

#include <iostream>

#include "Random.hpp"
#include "LinOp.hpp"
#include "LinAlg.hpp"
#include "IterSolver.hpp"
#include "RandSolver.hpp"

using namespace std;

int main( int argc, char **argv )
{
  long m = 1000;
  long n = 300;
  
  Mat_d A(m,n);
  Vec_d b(m);

  randn(A);
  randn(b);

  Vec_d x_lsqr(n);
  lsqr( A, b, 1e-14, 10000, x_lsqr );

  Vec_d sgm(n);
  Mat_d U(n,n);

  svd( A.copy(), sgm, U );
  
  Vec_d x_lscs(n);
  ls_chebyshev( A, b, sgm(0), sgm(n-1), 1e-14, x_lscs );

  Vec_d err(n);
  axpy( -1.0, x_lsqr, x_lscs );
  
  cout << nrm2(x_lscs)/nrm2(x_lsqr) << endl;
  
  return EXIT_SUCCESS;
}
