/**
 * @file   test_linop.cpp
 * @author Xiangrui Meng <mengxr@stanford.edu>
 * @date   Tue Oct  4 12:54:04 2011
 * 
 * @brief  
 * 
 * 
 */

#include <cstddef>

#include <iostream>

#include "Random.hpp"
#include "LinOp.hpp"

using namespace std;

int main( int argc, char **argv )
{
  Mat_d A(10,5);
  Mat_d B(5,3);
  Vec_d x(3);
  Vec_d y(10);
  Vec_d z(5);

  Composite_LinOP<double> AB( '*', A, B );

  randn(A);
  randn(B);
  randn(x);

  mv( 'n', 1.0, B, x, 0.0, z );
  mv( 'n', 1.0, A, z, 0.0, y );

  cout << y << endl;
  
  AB.mv( 'n', 1.0, x, 0.0, y );

  cout << y << endl;
  
  return EXIT_SUCCESS;
}
