/**
 * @file   test_lsne.cpp
 * @author Xiangrui Meng <mengxr@stanford.edu>
 * @date   Tue Oct  4 00:00:52 2011
 * 
 * @brief  
 * 
 * 
 */

#include <cstddef>

#include <iostream>

#include "Random.hpp"
#include "LinAlg.hpp"
#include "RandSolver.hpp"

using namespace std;

int main( int argc, char **argv )
{
  typedef ptrdiff_t idx_t;

  idx_t m = 1000;
  idx_t n = 100;
  
  Mat_d A(m,n);
  Vec_d b(m);

  randn( m*n, A.data() );
  randn( m, b.data() );

  Vec_d x(n);

  double rcond = 1e-12;
  idx_t  rank;

  lsne( A, b, rcond, x, rank );

  // compute residual 

  mv( 'n', 1.0, A, x, -1.0, b );
  mv( 't', 1.0, A, b, 0.0, x );

  cout << nrm2(x) << endl;
  
  return EXIT_SUCCESS;
}
