import sys

import numpy as np
from numpy.linalg import lstsq, norm, svd
from numpy.random import randn

def _gen_prob( m, n, cond, r = None ):

    if r is None:
        r = np.min([m,n])

    U, = svd(randn(m,r),False)[:1]
    s  = np.linspace(1,cond,r)
    V, = svd(randn(n,r),False)[:1]

    A   = (U*s).dot(V.T)
    b   = A.dot(randn(n))
    res = randn(m)
    theta = 0.25;
    b    += theta*norm(b) + res/norm(res)

    x_opt = V.dot(U.T.dot(b)/s)

    return A, b, x_opt

def _test():

    m     = 1e4
    n     = 1e2
    r     = np.ceil(n/2)
    cond  = 10.0
    rcond = 1.0/(10.0*cond);

    A, b, x_opt = _gen_prob(m,n,cond,r)

    x_lstsq, res, r_lstsq = lstsq(A,b,rcond)[:3]
    if not np.allclose(x_lstsq, x_opt):
        sys.exit( "Over-determined test failed." )

    A, b, x_opt = _gen_prob(n,m,cond,r) 

    x_lstsq, res, r_lstsq = lstsq(A,b,rcond)[:3]
    if not np.allclose(x_lstsq, x_opt):
        sys.exit( "Under-determined test failed." )

    print "All tests passed."

if __name__ == "__main__":
    _test()

