from math import sqrt, log

import numpy as np
from numpy.linalg import norm, lstsq

from scipy.sparse.linalg import LinearOperator, aslinearoperator

def ls_chebyshev( A, b, s_max, s_min, tol = 1e-8, iter_lim = None ):
    """
    Chebyshev iteration for linear least squares problems
    """

    A     = aslinearoperator(A)
    m, n  = A.shape
    
    d     = (s_max*s_max+s_min*s_min)/2.0
    c     = (s_max*s_max-s_min*s_min)/2.0

    theta   = (1.0-s_min/s_max)/(1.0+s_min/s_max) # convergence rate
    itn_est = np.ceil((log(tol)-log(2))/log(theta))
    if (iter_lim is None) or (iter_lim < itn_est):
        iter_lim = itn_est

    alpha = 0.0
    beta  = 0.0

    r     = b.copy()
    x     = np.zeros(n)
    v     = np.zeros(n)

    print iter_lim
    for k in xrange(int(iter_lim)):

        if k == 0:
            beta  = 0.0
            alpha = 1.0/d
        elif k == 1:
            beta  = -1.0/2.0*(c*c)/(d*d)
            alpha =  1.0*(d-c*c/(2.0*d))
        else:
            beta  = -(c*c)/4.0*(alpha*alpha)
            alpha = 1.0/(d-(c*c)/4.0*alpha)

        v  = A.rmatvec(r) - beta*v
        x += alpha*v
        r -= alpha*A.matvec(v)

    return x

def _test():

    m      = 100
    n      = 400
    A      = np.random.randn(m,n)
    s_max  = 1.02*(sqrt(n)+sqrt(m))
    s_min  = 0.98*(sqrt(n)-sqrt(m))
    b      = np.random.randn(m)
    x_opt, = lstsq(A,b)[:1]

    tol    = 1e-14
    x      = ls_chebyshev(A,b,s_max,s_min,tol)

    relerr = norm(x-x_opt)/norm(x_opt)

    print relerr

if __name__ == '__main__':
    _test()
