function [tx, trankA, tcondA, ts, x, rankA, condA, normA,...
          err, terr, ortherr, tortherr, s, V, tsInd, snzInd]...\
                = tevd7(A,b,V,s,shift,mu);
% Compute minimum length solution of small to medium size symmetric linear 
% least squares problem min||Ax-b||, given matrix A and vector b
%
% adopted from TSVD10.m
%   
% AUTHOR: Sou Cheng CHOI, SCCM, Stanford University
% 
% CREATION DATE: Oct 21, 2003
%  
% MODIFICATION HISTORY:
%    04/07/2005: 1. Corrected a bug by removing length() in:
%                   trankA  = length( find(ts>tol) );         
%                2. Rewritten help documentation 
  
format short e
n = length(A);  
%% compute full eig
if (nargin < 3) | isempty(V) | isempty(s)
   [V, s] = eig(full(A));
   %norm(A*V-V*s)
   shift = 0;
   s     = diag(s); % s sorted from negative to positive by EIG
end
err     = norm(A*V-V*diag(s));
sold    = s;
if shift ~= 0,
    s     = s - shift;
end
if ~exist('mu','var')
    mu      = 1;
end
%% pick the eigenvalues values significantly different from zero
%snzInd    = abs(s) > 0;
snzInd    = find( abs(s) > 0 );
snz       = s(snzInd);
rankA     = length(snz);
snzmax    = max( abs( snz ) );
normA     = snzmax;
snzmin    = min( abs( snz ) );
condA     = snzmax / snzmin;

%% pick the eigenvalues values significantly bigger than tol
%tsInd      = find(abs(s) > (mu * snzmax  * eps));
tsInd      = find( abs(s) > mu * snzmax  * eps );
ts         = s(tsInd);
trankA     = length(ts);
tsmax      = max( abs( ts ) );
tsmin      = min( abs( ts ) );
tcondA     = tsmax / tsmin;

terr    =  norm(A * V(:,tsInd) -  V(:,tsInd) * diag(sold(tsInd))); 
 
%% solve for minimum-length solution
if ~isempty(b)  % b <> []; 
   tx     = V(:,tsInd)*(diag(1./s(tsInd))*(V(:,tsInd)'*b));
   x      = V(:,snzInd)*(diag(1./s(snzInd))*(V(:,snzInd)'*b));
else
   x      = [];
   tx     = [];
end

ortherr = norm(V'*V-eye(n));
tortherr = norm(V(:,tsInd)'*V(:,tsInd)-eye(trankA));
%% print outputs
fprintf('\n EVD:  || AV - VD ||_2 = %10.2e\n', err);
fprintf('\n TEVD: || AV - VD ||_2 = %10.2e\n', terr);
fprintf('\n EVD: || V''V - I ||_2 ~= %10.2e\n', ortherr);
fprintf('\n TEVD: || V''V - I ||_2 ~= %10.2e\n', tortherr );
if (err > mu * snzmax * eps) || (terr > mu * snzmax * eps) || (ortherr > mu * snzmax * eps) || (ortherr > mu * snzmax * eps)
   warning('EIG results may not be accurate enough');
end

