function [DAD, D, e, condDAD] = diagscal5(A);
%
% DIAGSCAL: Diagonal Scaling of A
%  
% USAGE:
%
%        [DAD, D] = diagscal5(A); 
%     
% DESCRIPTION:
%
%    DIAGSCAL performs diagonal scaling of A 
%
% INPUTS:
%
%    A    real matrix, symmetric and nonsingular
%
% OUTPUTS:
%    
%    DAD  real matrix, symmetric, DAD = D * A * D; 
%         Diagonal elements of DAD are all ones. 
%    D    real sparse matrix, diagonal, d(i) = 1 / sqrt(A(i,i));
%    E    real vector, eigenvalues of DAD
%    condDAD real scalar, estimated condition number of DAD
%
% EXAMPLE(S):
% 
%    load('stiffMrx1');
%    [DAD, D] = diagscal(A);
%
% SEE ALSO:
%
%    READBRIDGE
%
% CITATION:
%
%    Sou-Cheng Choi, Linzhong Deng and Gene H. Golub, BRIDGE: MATLAB 
%    Software for ..., Research Software 
%    SCCM-SW-05-0?, SCCM Program, Stanford University, 2005.
%    Webpate: http://www-sccm.stanford.edu/pub/sccm/software/BRIDGE.m

%
% AUTHORS:
%
%    Sou-Cheng Choi, SCCM/ICME, Stanford University
%    Linzhong Deng,  SCCM/ICME, Stanford University
%    Gene H. Golub,  SCCM/ICME and CS, Stanford University
%    Michael A. Saunders,  SCCM/ICME and MS&E, Stanford University
%
% VERSION:
%
%    1   
%
% CURRENT AND PREVIOUS RELEASED VERSIONS:
%
%    1
%
% CREATION DATE: 
% 
%    08/15/2005
%
% MODIFICATION HISTORY:
%
%    ??/??/22005: 
%

%
% NOTES:
%
%
% ACKNOWLEDGEMENT:
%


%
% COPYRIGH NOTICE:
%
%    This is Copyrighted Material. The software is COPYRIGHTED by the  
%    original authors.
% 
% COPYLEFT NOTICE:
%
%     Permission is granted to make and distribute verbatim copies of this 
%     file, provided that the entire file is copied **together** as a 
%     **unit**.
% 
%     The purpose of this permission notice is to allow you to make copies 
%     of the software and distribute them to others, for free or for a fee, 
%     subject to the constraint that you maintain the entire file here 
%     as a unit.  This enables people you give the software to to be aware 
%     of its origins, to ask questions of us by e-mail, to request  
%     improvements, obtain later releases, and so forth.
% 
%     If you seek permission to copy and distribute translations of this 
%     software into another language, please e-mail a specific request to
%     golub@stanford.edu and choi@sccm.stanford.edu.
% 
%     If you seek permission to excerpt a **part** of the software library 
%     for example to appear in a scientific publication, please e-mail a 
%     specific request to golub@stanford.edu and choi@sccm.stanford.edu.
% 
% COMMENTS? 
%
%     E-mail choi@sccm.stanford.edu, ldeng@stanford.edu and
%     golub@stanford.edu 
%
format short e

%% Computing D and DAD
n = length(A);
D = sqrt ( max ( abs(A) ) )';  % sqrt of max element of each column
D = 1./max(eps,D); % no division by zero since A is nonsingular 
D = spdiags(D,0,n,n); 
DAD = D*A*D; % "unsymmetric" due to floating-point errors
DAD = (DAD + DAD')/2;  % made symmetric for fast eigenvalue computations using EIG

%% Analysis
e = sort(eig(full(DAD)));
%plot(e); title('Eigenvalues of DAD');
condDAD = abs(e(n)/e(1))