function [x, err] = eigFit(eigvec, gamavec, markerstring1, markerstring2)
%        [x, err] = eigFit(eigvec, gamavec, markerstring1, markerstring2)
%
% Example:
%    eigvec   = [ 1 2 3 4];
%    gamavec  = [ -1.2 0.7 1.1 2.3 3.4 2.5 3.9 4.9];
%    [x, err] = eigFit(eigvec, gamavec, 'b-.', 'rO');
% Creation Date:
%    Apr 08, 2006.


%% compute index vector x
n = length(gamavec);
x = zeros(size(gamavec)); 
err = zeros(size(gamavec)); 
for i = 1:n,
    [err(i), x(i)] = min( abs( gamavec(i) - eigvec ) );  
end

%% plot graph
plot(eigvec, markerstring1); hold on;
plot(x, gamavec, markerstring2);

% make left and right margins. Syntax note: AXIS([XMIN XMAX YMIN YMAX]);  
v = axis; 
c1 = 0;

h1 =  floor(c1*(v(2)-v(1)));
axis([v(1)-h1 v(2)+h1 v(3) v(4)])

hold off;
 