%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% private function plotEigGamma
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function plotEigGamma(figno, n, ts, gamavecQLP, gamavecSOL, alfavecQLP, betavecQLP, alfavecSOL, betavecSOL, mu)
figure(figno)
options={'Interpreter','latex'};
tol = eps * max(abs([ts(1), ts(end)])) * mu;
 
% The following two graphs could overlap
TQLP = diag(betavecQLP(1:end-1),1) + diag(alfavecQLP,0) + diag(betavecQLP(1:end-1),-1);
absEigTQLP = abs(eig(TQLP));
 
TSOL = diag(betavecSOL(1:end-1),1) + diag(alfavecSOL,0) + diag(betavecSOL(1:end-1),-1);
absEigTSOL = abs(eig(TSOL));
 
mfig=2; nfig=3;
ts = flipud(sort(abs(ts)));
subplot(mfig,nfig,1) 
plot(ts,'b.');  title(['nonzero $\sigma(A) = |\lambda(A)|, n = ', num2str(n), '$'], options{1,1}, options{1,2})
axis square; 

subplot(mfig,nfig,5) 
[x, err] = eigFit(ts, gamavecQLP, 'b.', 'rO');
title(['$\gamma_k^Q, k = ', num2str(length(gamavecQLP)), '$'], options{1,1}, options{1,2});
axis square; 
 
subplot(mfig,nfig,6)
semilogy(x, abs(err), 'kx'); title('$| \gamma_k^Q - \sigma(A) |$', options{1,1}, options{1,2});
axis square; 

subplot(mfig,nfig,2)
[x, err] = eigFit(ts, gamavecSOL, 'b.', 'rO');
title(['$\gamma_k^M, k = ', num2str(length(gamavecSOL)), '$'], options{1,1}, options{1,2});
axis square;  
 
subplot(mfig,nfig,3) 
semilogy(x, abs(err), 'kx'); title('$| \gamma_k^M - \sigma(A) |$', options{1,1}, options{1,2});
axis square;   

