function printflagmsg(methodno,flag)

% Methods:
%  1 : EVD
%  2 : TEVD
%  3 : MINRES QLP49
%  4 : Matlab 7 LSQR

switch methodno
  case 3 % MINRES-SOL
    switch flag
      case -1 
	fprintf('beta2 = 0.  If M = I, b and x are eigenvectors.')
      case 0  
	fprintf('beta1 = 0.  The exact solution is  x = 0.')
      case 1  
	fprintf('A solution to (poss. singular) Ax = b found, given rtol.')
      case 2  
	fprintf('A least-squares solution was found, given rtol.')
      case 3  
	fprintf('A solution to (poss. singular) Ax = b found, given eps.')
      case 4  
	fprintf('A least-squares solution was found, given eps.')
      case 5  
	fprintf('x has converged to an eigenvector.')
      case 6  
	fprintf('xnorm has exceeded maxxnorm.')
      case 7  
	fprintf('Acond has exceeded 0.1/eps.')   
      case 8  
	fprintf('The iteration limit was reached.')   
      case 9  
	fprintf('Pseudoinverse solution for singular LS problem, given eps.')
      case 10 
	fprintf('Pseudoinverse solution for singular LS problem, given rtol.')
      case 11
	fprintf('A null vector obtained, given rtol.')
    end

  case 4 % MINRES-QLP
    switch flag
      case -1 
	fprintf('beta2 = 0. If M = I, b and x are eigenvectors.')
      case 0 
	fprintf('beta1 = 0.  The exact solution is  x = 0.')
      case 1 
	fprintf('A solution to (poss. singular) Ax = b found, given rtol.')
      case 2 
	fprintf('Pseudoinverse solution for singular LS problem, given rtol.')
      case 3 
	fprintf('A solution to (poss. singular) Ax = b found, given eps.')
      case 4 
	fprintf('Pseudoinverse solution for singular LS problem, given eps.')
      case 5 
	fprintf('x has converged to an eigenvector.')
      case 6 
	fprintf('xnorm has exceeded maxxnorm.')
      case 7 
	fprintf('Acond has exceeded Acondlim.')   
      case 8 
	fprintf('The iteration limit was reached.')
      case 9 
	fprintf('It is a least squares problem but no converged solution yet.')
      case 10
	fprintf('A null vector obtained, given rtol.')
    end  
  otherwise
    fprintf('Unknown method.')
end
