function DPtestLSSing5
% run DPtestLSSing5

% 04 May 2006: Original script obtained from Gerard Sleijpen.
%              Used by Sleijpen, Van Der Vorst and Modersitzki,
%              SIMAX 22(3) 726-751 (2000) for testing MINRES.
%
% 06 May 2006: Modified slightly by Sou-Cheng Choi and Michael Saunders.
%              A private function allows multiple tests with
%              varying cond(A), norm(x), and stopping tolerance.
%
% 23 Aug 2009: Renamed DPtestLSSing5 to DPtestLSSing5. 
%              Cleaned up the script. 
%              Updated minresQLP43 to minresQLP49.
%
% 25 Mar 2010: More cleanup.

  close all

  %   small,  bigx,  tol , iter, subplot, precision
  test(1e-2,     1, 2e-9,   90,   1,  1);  % Original test:  large x
  test(1e-4,     0, 2e-9,   90,   2,  1);  % Same A,         small x
  test(1e-6,     1, 2e-9,   90,   3,  1);  % Bigger cond(A), large x
  test(1e-8,     0, 2e-9,   90,   4,  1);  % Same A,         small x
 
  h = figure(1); 
  set(h, 'Position',  [216    96   983   819]);
  h = figure(2); 
  set(h, 'Position',  [216    96   983   819]);
  text(-10, 7,'Four (singular) symmetric least squares problems.');
  print(gcf, '-depsc2', ['DPtestLSSing3_DP.eps']) 
 
% end main function

function test(small,bigx,tol,max_iter,fig, precision)

  q   = 5;
  h   = 1/789;
  z   = [zeros(1,q), small, 2*small, 2:h:3]';
  n   = length(z);
  A   = spdiags(z,0,n,n);
 
  rand('state',0);
  %Q  = orth(rand(n));
  vHH = ones(n,1);  %rand(n,1);  %sqrt((1:n)'); 
  vHH = vHH / norm(vHH);

  if bigx
    b = ones(n,1); 
  else % b = A * ones(n,1);
    b = [ones(q,1); small; 2*small; ones(n-q-2,1)];
  end

  epsilon  = eps;
 
  normA    = 3;
  condA    = normA/small;
  normb    = norm(b);

  rtol     = tol;% 1e-15;
  maxit    = 1000;
  M        = [];
  shift    = 0;
  maxxnorm = 10^14; %10^(16-log10(condA));
  Acondlim = [];
  show     = 1;
  testsym  = 0;
  fignum   = 0;
  debug    = 0;
  disable  = 0;
  isbestiter = 0;


  tic
  [x, flag, iter, rnorm, Arnorm, Anorm, Acond, xnorm, tknorm            ...
	resvec, Aresvec, xnormvec, pnormvec, gamavec, alfavec, betavec, ...
	VV, resvecdirect, relresvec, Aresvecdirect, relAresvec] = ...
      minresSOL69( @minresproduct, b, rtol, maxit, M, shift, maxxnorm, Acondlim, ...
                   show, testsym, fignum, debug, disable, isbestiter, A, vHH );  
  toc
    
  tic
  [xQLP, flagQLP, iterQLP, rnormQLP, ArnormQLP, AnormQLP, AcondQLP, xnormQLP, tknormQLP, ...
     resvecQLP,  AresvecQLP, xnormvecQLP, pnormvecQLP,  gamavecQLP, ...
     alfavecQLP, betavecQLP, veplnvecQLP, etavecQLP, VVQLP, resvecdirectQLP, relresvecQLP, ...
     AresvecdirectQLP, relAresvecQLP, xnormdirectvecQLP] = ...
	minresQLP49( @minresproduct, b, rtol, maxit, M, shift, maxxnorm, Acondlim, ...
                     show, testsym, fignum, debug, disable, isbestiter, A, vHH );
  toc
  
  options = {'Interpreter','latex'};
  figure(1)
  h1 = subplot(2,2,fig);
  hold off
 
  semilogy(resvecdirect,'-b')
  hold on
  semilogy(resvec,'b.')
  semilogy(resvecdirectQLP,'--r')
  semilogy(resvecQLP,'ro')
 
  semilogy([1; length(resvec)], tol*ones(2,1), ':k')
 
  semilogy([1; length(resvec)], tol*ones(2,1), ':k')
  
  semilogy(resvecdirect ./ (normA.*xnormvec + normb),'-b')
  hold on
  semilogy(relresvec,'b.')
  
  semilogy(resvecdirectQLP ./ (normA.*xnormdirectvecQLP + normb),'--r')
  semilogy(relresvecQLP,'ro')
  
  if fig == 1
    ht=legend('$\| r_k^M\|$',  '$\phi_k^M$', '$\| r_k^Q\|$',  '$\phi_k^Q$' , 3);
    set(ht,options{:});
  end
  
  ht = title(['$\kappa \approx 10^{', num2str(round(log10(condA))),...
   '},  || A || = ', num2str(normA),...
   ',   || x || \approx 10^{', num2str(round(log10(xnorm))),...
   '},  || b || \approx 10^{', num2str(round(log10(normb))),...
   '},  tol = 10^{', num2str(round(log10(tol))),'}$'],options{:});
    
  set(ht,'fontsize',8);
  axis tight;
 
  xlabel('$k$', options{:});
 %ylabel('$ \| r_k \|_2 $',options{:});
   
  set(h1, 'Ylim' , [1e-15, 10^3]);
  set(h1, 'YTick', [1e-15 1e-10 1e-5 1 ]);
  
  figure(2)
  h2 = subplot(2,2,fig);
  hold off
 
  semilogy(Aresvecdirect,'-b')
  hold on
  semilogy(Aresvec,'b.')
  semilogy(AresvecdirectQLP,'--r')
  semilogy(AresvecQLP,'ro')
   
  semilogy([1; length(resvec)], tol*ones(2,1), ':k')
 
 %semilogy(Aresvecdirect ./(normA .* resvecdirect),'-b')
 %hold on
 %semilogy(relAresvec,'b.')

 %semilogy(AresvecdirectQLP ./(normA .* resvecdirectQLP),'--r')
 %semilogy(relAresvecQLP,'ro')
 
  if fig == 1
    ht = legend('$\|A r_k^M\|$', '$\psi_{\phantom{1}k} ^{\phantom{1}M}$', ...
	        '$\|A r_k^Q\|$', '$\psi_{\phantom{1}k} ^{\phantom{1}Q}$', 3);
    set(ht,options{:});
  end
  
  ht = title(['$\kappa \approx 10^{', num2str(round(log10(condA))),...
   '},  || A || = '          , num2str(normA),...
   ',   || x || \approx 10^{', num2str(round(log10(xnorm))),...
   '},  || b || \approx 10^{', num2str(round(log10(normb))),...
   '},  tol = 10^{'          , num2str(round(log10(tol))),'}$'], options{:});
    
  set(ht,'fontsize',8);
  axis tight;
 
  xlabel('$k$', options{:});
 
  if fig ~= 3
    set(h2, 'Ylim',[1e-10, 10]);
  else 
    set(h2, 'Ylim',[1e-10, 10^3]);
  end
  set(h2, 'YTick', [1e-10  1e-5 1 ]); 
% end private function test

function y = minresproduct(x,varargin)

  temp = varargin{1};
  temp = temp{1,1};
  
  A = temp{1,1};
  v = temp{1,2};
  w = x - (2*(v'*x))*v;
  w = full(A*w);
  y = w - (2*(v'*w))*v;
 
