function DPtestSing7
% run DPtestSing7

% 04 May 2006: Original script obtained from Gerard Sleijpen.
%              Used by Sleijpen, Van Der Vorst and Modersitzki,
%              SIMAX 22(3) 726-751 (2000) for testing MINRES.
%
% 06 May 2006: Modified slightly by Sou-Cheng Choi and Michael Saunders.
%              A private function allows multiple tests with
%              varying cond(A), norm(x), and stopping tolerance.
%
% 23 Aug 2009: Renamed DPtestSing5.m to DPtestSing7.m. 
%              Cleaned up the script. 
%              Updated minresQLP43 to minresQLP49.
%
% 25 Mar 2010: More cleanup.

  figure(1)
  clf

%     small , bigx,  tol , iter, subplot, precision
  test(1e-8 ,    1, 1e-14,   90,   1,  1);  % Original test:  large x
  test(1e-8 ,    0, 1e-14,   90,   2,  1);  % Same A,         small x
  test(1e-10,    1, 1e-14,   90,   3,  1);  % Bigger cond(A), large x
  test(1e-10,    0, 1e-14,   90,   4,  1);  % Same A,         small x
% test(1e-15,    1, 1e-13,   90,   5,  1);  % Bigger cond(A), large x
% test(1e-15,    0, 1e-16,   90,   6,  1);  % Same A,         small x

  h  = figure(1); 
  set(h, 'Position',  [216    96   983   819]);
  text(-18, 7.8e23,'Four symmetric positive semidefinite ill-conditioned systems.');
  %ht = text(-5, 7.8e23,'$Ax = b$');
  print(gcf, '-depsc2', ['DPtestSing5_DP.eps']) 
  
  %keyboard

% figure(2);
% clf; 
% %     small , bigx,  tol , iter, fig, precision
%   test(1e-4 ,   1, 1e-5,   90,   1,  2);  % Original test:  large x
%   test(1e-4 ,   0, 1e-5,   90,   2,  2);  % Same A,         small x
%   test(1e-6,    1, 1e-6,   90,   3,  2);  % Bigger cond(A), large x
%   test(1e-6,    0, 1e-6,   90,   4,  2);  % Same A,         small x
%   test(1e-8,    1, 1e-7,   90,   5,  2);  % Bigger cond(A), large x
%   test(1e-8,    0, 1e-7,   90,   6,  2);  % Same A,         small x
%   print(gcf, '-depsc2', ['DPtest3_SP.eps']) 

% end main function

function test(small,bigx,tol,max_iter,fig, precision)

  q = 5;
  h = 1/789;
  z = [zeros(1,q), small, 2*small, 2:h:3]';
  n = length(z);
  A = spdiags(z,0,n,n);
  %c = sqrt(2)/2;
  %s = c;
  %G = [c  s
  %    -s  c];
  %A([1 30],[1 30]) = G * A([1 30],[1 30]) * G';
  %   rand('state',0);
  %   Q = orth(rand(n));
  %   A = Q'* A * Q;
  
  vHH = [zeros(q,1); ones(n-q,1)]; %rand(n,1);  %sqrt((1:n)'); 
  vHH = vHH / norm(vHH);
  
% if bigx
%   b = ones(n,1);
% else 
%   b = A * ones(n,1);
% end
  
  if bigx
    b = [zeros(q,1); ones(n-q,1)]; 
  else % b = A * ones(n,1);
    b = [zeros(q,1); ones(n-q,1)]; 
    w = b - (2*(vHH'*b))*vHH;
    w = full(A*w);
    b = w - (2*(vHH'*w))*vHH;
    %minresproduct(ones(n,1),A,vHH); 
  end
  
  %if precision ~= 1
  %  A = single(full(A));
  %  b = single(b);
  %  epsilon = 1.2e-7;
  %else 
     epsilon = eps;
  %end
  
  %tic
  %[x,NORM_r, NORM_rdirect, NORM_x] = MINRES3(A,b,[],[tol,max_iter]);
  %toc
  normA     = 3; %normest(A);
  condA     = normA/small;
 %condA     = condest(A);
  normb     = norm(b);
 %normx     = norm(x);
 %relresvec = NORM_r ./ (normA * NORM_x + normb);
  
  rtol      = tol;  % 1e-15;
  maxit     = 1000;
  M         = [];
  shift     = 0;
  maxxnorm  = 1e14; %10^(16-log10(condA));
  Acondlim  = [];
  show      = 1;
  testsym   = 0;
  fignum    = 0;
  debug     = 0;
  disable   = 0;
  isbestiter= 0;


  tic
  [x, flag, iter, rnorm, Arnorm, Anorm, Acond, xnorm, tknorm,                 ...
	resvec,  Aresvec, xnormvec, pnormvec,  gamavec, alfavec, betavec, VV, ...
	resvecdirect, relresvec, Aresvecdirect, relAresvec, pnormdirectvec,   ...
	tknormvec] =  ...
      minresSOL69( @minresproduct, b, rtol, maxit, M, shift, maxxnorm, Acondlim, ...
                   show, testsym, fignum, debug, disable, isbestiter, A, vHH );
  toc
    
  tic
  [xQLP, flagQLP, iterQLP, rnormQLP, ArnormQLP, AnormQLP, AcondQLP, xnormQLP, tknormQLP,     ...
	resvecQLP, AresvecQLP, xnormvecQLP, pnormvecQLP, gamavecQLP,                         ...
	alfavecQLP, betavecQLP, veplnvecQLP, etavecQLP, VVQLP, resvecdirectQLP,              ...
        relresvecQLP, AresvecdirectQLP, relAresvecQLP, xnormdirectvecQLP, pnormdirectvecQLP, ...
	tknormvecQLP] = ...
      minresQLP49( @minresproduct, b, rtol, maxit, M, shift, maxxnorm, Acondlim, ...
                   show, testsym, fignum, debug, disable, isbestiter, A, vHH );
  toc

  options = {'Interpreter','latex'};
  subplot(2,2,fig)
  hold off 
  h = subplot(2,2,fig);
  hold off  
 
  semilogy(resvecdirect,'-b'); 
  hold on  
  semilogy(resvec,'b.')
  
  semilogy(resvecdirectQLP,'--r')
  semilogy(resvecQLP,'ro')
     
  semilogy([1; length(resvec)], tol*ones(2,1), ':k')
  
  semilogy(resvecdirect ./(normA.*xnormvec + normb),'-b');
  hold on
  semilogy(relresvec,'b.')
  
  semilogy(resvecdirectQLP ./(normA.*xnormdirectvecQLP + normb),'--r')
  semilogy(relresvecQLP,'ro')
  
  
  if fig == 1
     ht = legend('$\|r_k^M\|$', '$\phi_k^M$', '$\|r_k^Q\|$', '$\phi_k^Q$', 3);
     set(ht,options{:}, 'fontsize',8);
  end

  %legend(['\rho_k','||r_k||', 'SOL65 \rho_k',  'SOL65 ||r_k||', 'QLP37 \rho_k',...
  %        'QLP37 ||r_k||', '\rho_k/(||A||||x_k||+||b||)'],['tol=', sprintf('%1.0e',tol)]); 
  
  ht = title(['$\kappa \approx 10^{', num2str(round(log10(condA))),...
    '},  || A || = '          , num2str(normA),...
    ',   || x || \approx 10^{', num2str(round(log10(xnorm))),...
    '},  || b || \approx 10^{', num2str(round(log10(normb))),...
    '},  tol = 10^{'          , num2str(round(log10(tol))),'}$'],options{:});
    
  set(ht,'fontsize',8);
  axis tight;
  xlabel('$k$', options{:});
  
  if fig ~= 3
    set(h, 'Ylim', [1e-15, 10]);
  else 
    set(h, 'Ylim', [1e-15, 10^3]);
  end
  set(h, 'YTick', [1e-15 1e-10 1e-5 1 ]);
% end private function test

function y = minresproduct(x,varargin)
  temp = varargin{1};
  temp = temp{1,1};
% temp = temp{1,1};
 
  A = temp{1,1};
  v = temp{1,2};
  w = x - (2*(v'*x))*v;
  w = full(A*w);
  y = w - (2*(v'*w))*v;
