function A = QLPfig5

% QLPfig: demostrate how QLP works on symmetric tridiagonal matrix 
%  
% USAGE:
%        A = QLPfig5; 
%
% DESCRIPTION:
%    demonstrate how two versions of Stewart's QLP works on 
%    long, symmetric tridiagonal matrix 
%              T_k_bar := [T_k; 0 beta_k+1]
%    produced from MINRES. 
%    (i)  First  version of QLP: no interleaving on T_k_bar
%    (ii) Second version of QLP: with interleaving on T_k_bar
%
% INPUTS:
%    n    size of T_k, so T_k_bar has size (n+1) * n
%    t    optional, pause time
%
% OUTPUTS:
%    figures(1)  two subplots
%    A           nnz(A) indicate how many times the entry has been changed
%
% EXAMPLE:
%     QLPfig
%
% SEE ALSO:
%    ---
%
% REFERENCES:
%    Stewart, QLP (1990) SIAM Sci Comp Vol 20 No 4
%
% FUTURE WORK:
%    MM/DD/2004: ---
%
% MODIFICATION HISTORY:
%    09/21/2009: Modified QLPfig3.m and saved it as QLPfig5.m. 
%                Reduced the figure size by half.
%    12/10/2004: (1) Figure out repeation patten along each column from 3rd
%                column onwards
%                (2) To highlight the two columns/rows being changed in
%                figure
%
%
% KNOWN BUGS:
%    MM/DD/2004: ---
%
% NOTES:
%    MM/DD/2004: ---
%
% AUTHOR: Sou Cheng Choi, SCCM, Stanford University
%         Michael Saunders, SOL, Stanford University
%
% CREATION DATE: 12/10/2004

close all
n = 5;
h = figure(1);
set(h, 'Position', [305   145   875   780]);
h = subplot(2,2,1);
e = ones(n,1);
A = spdiags([e e e], -1:1, n, n);
A = [full(A); zeros(1,n-1) 1];

mfig = 3;
nfig = 5
ifig = 1;
ifxlabel = 0;
 
t = 0.25;
 

disp('===================QLP, Q and P interleaved========');
h   = subplot(mfig,nfig,ifig);
spy(A,'+k',  ifxlabel);
pos = get(h, 'Position');
set(h, 'XTick',[],'YTick',[], 'Position',pos);
title('A');
titlestr = '';

for i=2:3
    ifig = ifig+1;
    h = subplot(mfig,nfig,ifig);
    pos = get(h, 'Position');
    A = ZeroOut(A, i, i-1, 1, t, titlestr);
    set(h, 'XTick',[],'YTick',[], 'Position',pos);
end

j    = 1;
ifig = ifig+1;
h    = subplot(mfig,nfig,ifig);
A    = ZeroOut(A, j, j+1, 2, t, titlestr);
pos  = get(h, 'Position');
set(h, 'XTick',[],'YTick',[],'Position',pos);

for i=4:n+1
    j    = j + 1;
    ifig = ifig+1;
    h    = subplot(mfig,nfig,ifig);
    A    = ZeroOut(A, i,  i-1, 1, t, titlestr);
    pos  = get(h, 'Position');
    set(h, 'XTick',[],'YTick',[], 'Position',pos);
    ifig = ifig+1;
    h    = subplot(mfig,nfig,ifig);
    A    = ZeroOut(A, j-1,j+1, 2, t, titlestr);
    pos  = get(h, 'Position');
    set(h, 'XTick',[],'YTick',[], 'Position',pos);
    ifig = ifig+1;
    if i < n + 1
       titlestr = '';
    else
       titlestr = 'L';
    end
    h   = subplot(mfig,nfig,ifig);
    pos = get(h, 'Position');
    A   = ZeroOut(A, j  ,j+1, 2, t, titlestr);
    set(h, 'XTick',[],'YTick',[], 'Position',pos);
end



function A = ZeroOut(A,i,j,k,t,titlestr)

ifxlabel = 0;
[m,n]    = size(A);
B  = zeros(size(A));
C  = zeros(size(A));
hold on

if k==1 % Qij from the left
  % highlight the i-th and j-th rows
  B(i,:) = A(i,:);
  B(j,:) = A(j,:);
  title(titlestr);
  spy(B, '+k', ifxlabel); hold on;
  title(titlestr);
  
  C(i,j) = A(i,j);
  spy(C, 'ok', ifxlabel);
  title(titlestr);
  
  C(i,j)     = 0;
  C(i-1,i-1) = A(i-1,i-1);
  spy(C, 'pk', ifxlabel);
  title(titlestr);
  pause(t);   
  hold off
  
  % linear combinations of i-th and j-th rows
  A(i,j) = 0;
  A(j,:) = A(i,:) + A(j,:);

  % highlight the i-th and j-th rows

  spy(A, '+k', ifxlabel); hold on;
  title(titlestr);
  hold on
  B(i,:) = A(i,:);
  B(j,:) = A(j,:);
  spy(B, 'xk', ifxlabel); hold on
  title(titlestr);
  D      = zeros(size(B));
  D(i,j) = 1;
  spy(D, 'ok', ifxlabel);

else    % Pij from the right
    
  % highlight the i-th and j-th columns
  B(:,i) = A(:,i);
  B(:,j) = A(:,j);
  spy(B, '+k', ifxlabel); hold on
  title(titlestr);
  
  C(i,j) = A(i,j);
  spy(C, 'ok', ifxlabel);
  
  C(i,j) = 0;
  C(i,i) = A(i,i);
  spy(C, 'pk', ifxlabel);
  title(titlestr);
  
  pause(t);
  hold off;
  
  % linear combinations of i-th and j-th columns
  A(i,j) = 0;
  A(:,i) = A(:,i) + A(:,j);
 
  spy(A, '+k', ifxlabel);
  title(titlestr);
  hold on
  B(:,i) = A(:,i);
  B(:,j) = A(:,j);
  spy(B, 'xk', ifxlabel);
  title(titlestr);
 
  D      = zeros(size(B));
  D(i,j) = 1;
  spy(D, 'ok', ifxlabel)
end


spy(A, '+k', ifxlabel);
title(titlestr);
pause(t);

  
function Blackout(A, rind, cind);

hold on
B            = zeros(size(A));
B(rind,cind) = A(rind, cind);
spy(B, '+k', ifxlabel);
 
