function testminresQLPNormA8

%        testminresQLPNormA8
% creates Figure 6.1 in Choi, Paige, and Saunders
% (submitted to SISC March 2010).
% It constructs 12 test matrices and runs them on
% minres and minres-QLP, comparing various estimates of norm(A).
%
% AUTHORS: Sou Cheng Choi, iCME, Stanford University
%          Michael Saunders, SOL, Stanford University
%
% 29 Mar 2010: Current version of testminresQLPNormA8.

close all
format compact
format short e

disp('======================= Set up input parameters ========================')

rand('state', 0)

M        = [];
iw       = [];
rw       = [];
Acondlim = [];
precond  = false;
shift    = 0;
show     = false; %true;
maxxnorm = 1e9;
rtol     = 100*eps;
debug    = 0;
isbestiter = 0

errevd   = -1;  
errtevd  = -1;   
errMM    = -1;
err      = -1;
err1     = -1;
err2     = -1;
errpcg   = -1;
errsym   = -1;
errMS    = -1;

mu       = 1;
isdiag   = 0;
diary testminresQLPNormA8.txt

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Print header
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
fprintf('\nMethods:')
fprintf('\n 1 : EVD.                      ')
fprintf('\n 2 : NORMEST.                  ')
fprintf('\n 3 : max_i {gamma_i}.          ')
fprintf('\n 4 : max_i {||p_i||}.          ')
fprintf('\n 5 : max_i {|| Tk e_i ||.      ')
fprintf('\n 6 : || [alfa1 ; betavec] ||.  ')
fprintf('\n 7 : ||Tk||_F                  ')

xind = 0;
    
for probnum = [1  4  5 8 9 12 13 16 17 18 20 21] 
  xind = xind + 1;
  [A,b,shift,n,id,itnlim,isdiag] = ConstructProblem(probnum);

  beta1 = norm(b);
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %% Print Inputs
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  nnzA = nnz(A-shift*speye(n));

  %% Truncated EVD solution

  if n<5000,
    if isdiag
      filename = ['Davis', num2str(id), 'Case', num2str(probnum), 'DAD', 'Eig'];
    else
      filename = ['Davis', num2str(id), 'Case', num2str(probnum), 'Eig'];
    end
    %if ~exist([filename,'.mat']) % Run EVD only once --- with shift = 0 !  :)
    fprintf('\nComputing EVD and TEVD of A and the solutions...')

    [tx, trankA, tcondA, ts, xevd, rankA, condA, normA, ...
          errVD, terrVD, ortherr, tortherr, s, V, tsInd, snzInd] = tevd7(A,b);

    fprintf('\nSaving EVD and TEVD of A in %s...', filename)
    save(filename, 's', 'V');
    ss = s;
    if shift ~= 0
      ss = ss - shift;
    end
    % else
    %   fprintf('\nLoading EVD and TEVD of A from %s and computing the solutions...', filename)
    %   load(filename);
    %   [tx, trankA, tcondA, ts, xevd, rankA, condA, normA, ...
    %         errVD,terrVD, ss, V, tsInd, snzInd] = tevd3(A,b,V,s,shift,mu);
    % end
  end
    
  ifplot = 1; 
  [x1, istopSOL, itn1, rnorm1, Arnorm1, Anorm1, Acond1, xnorm1, tknorm1, ...
     resvec, Aresvec, xnormvec, pnormvecSOL, gamavecSOL, alfavecSOL, betavecSOL, VV, ...
     resvecdirect, relresvec, Aresvecdirect, relAresvec,  pnormdirectvec] = ...
     minresSOL69( A, b, rtol, itnlim, M, shift, maxxnorm, Acondlim, show, ifplot, debug, isbestiter);

 
  % disp('========================= minresQLP49 ========================')
  
  ifplot     = 1; 
  [x2, istopQLP, itn2, rnorm2, Arnorm2, Anorm2, Acond2, xnorm2, tknorm2, ...
     resvec2, Aresvec2, xnormvec2, pnormvecQLP, gamavecQLP, alfavecQLP, betavecQLP, veplnvecQLP, etavecQLP, VVmatQLP, ...
     resvecdirect, relresvec, Aresvecdirect, relAresvec,xnormdirectvec, pnormdirectvecQLP  ] = ...
     minresQLP49( A,  b,  rtol, itnlim,  M, shift, maxxnorm, Acondlim, show, ifplot, debug, isbestiter);

 % r2         = b-A*x2+shift*x2;
 % rnorm2out  = norm(r2)/(normA * xnorm2 + beta1);
 % Arnorm2out = norm(A*r2 - shift*r2)/(normA * norm(r2));
 % if exist('xevd'), 
 %   err2 = norm(tx - x2); 
 % end

 %% Anorm-SOL computed in different ways

  kSOL = length(alfavecSOL);
  TkSOL = diag(betavecSOL(1:end-1),1) + diag(alfavecSOL,0) + diag(betavecSOL(1:end-1),-1);
  % Tkbar = [Tk;
  %         [zeros(1,k-1) betavecSOL(end)] ];
    
  normA2_1SOL(xind) = normA; % from EVD

  [normA2_2SOL(xind), ind2SOL(xind)] = normest(A, 1e-3);
  errA2_2SOL(xind)  = abs((normA2_1SOL(xind) - normA2_2SOL(xind)))/normA2_1SOL(xind);
     
  [normA2_3SOL(xind), ind3SOL(xind)] = max(gamavecSOL);
  errA2_3SOL(xind)  = abs((normA2_1SOL(xind) - normA2_3SOL(xind)))/normA2_1SOL(xind);
    
  [normA2_4SOL(xind), ind4SOL(xind)] = max(pnormdirectvec);   
  errA2_4SOL(xind)  = abs((normA2_1SOL(xind) - normA2_4SOL(xind)))/normA2_1SOL(xind) ;

  [normA2_5SOL(xind), ind5SOL(xind)] = max(pnormvecSOL);  
  errA2_5SOL(xind)  = abs((normA2_1SOL(xind) - normA2_5SOL(xind)))/normA2_1SOL(xind); 
    
  normA2_6SOL(xind) = norm( [alfavecSOL(1); betavecSOL] );
  errA2_6SOL(xind)  = abs((normA2_6SOL(xind) - normA2_1SOL(xind)))/normA2_1SOL(xind); 

  normAF_1SOL(xind) = norm(ss);
    
  normAF_2SOL(xind) = norm(TkSOL, 'fro');
  errAF_2SOL(xind)  = abs((normAF_2SOL(xind) - normAF_1SOL(xind)))/normAF_1SOL(xind);

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %% Print Estimates
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % header

  fprintf('\nID = %d,   n = %d,  shift = %10.3e,  MINRES_SOL itns = %10d', id, n, shift, itn2)
    
  fprintf('\nMethod :   1          2        (i)      3        (i)      4       (i)       5        (i)      6 ')
  fprintf('\n||A||_2: %10.1e %10.1e (%4d) %10.1e (%4d) %10.1e (%4d) %10.1e (%4d) %10.1e %10.1e %10.1e ', ...
      normA2_1SOL(xind), normA2_2SOL(xind), ind2SOL(xind), normA2_3SOL(xind), ind3SOL(xind),...
      normA2_4SOL(xind), ind4SOL(xind), normA2_5SOL(xind), ind5SOL(xind), normA2_6SOL(xind) )
  fprintf('\nError  :            %10.1e        %10.1e        %10.1e        %10.1e        %10.1e',...
      errA2_2SOL(xind), errA2_3SOL(xind), errA2_4SOL(xind), errA2_5SOL(xind), errA2_6SOL(xind))
  fprintf('\nMethod :   1          8')
  fprintf('\n||A||_F: %10.1e %10.1e', normAF_1SOL(xind), normAF_2SOL(xind) )
  fprintf('\nError  :            %10.1e', errAF_2SOL(xind))
  fprintf('\n')

  %% Anorm-QLP computed in different ways

  k  = length(alfavecQLP);
  Tk = diag(betavecQLP(1:end-1),1) + diag(alfavecQLP,0) + diag(betavecQLP(1:end-1),-1);
  Lk = diag(veplnvecQLP(2:end),-1) + diag(gamavecQLP,0) + diag(etavecQLP(3:end),-2);
    
  Tkbar        = [Tk; zeros(1,k)];
  Tkbar(k+1,k) = betavecQLP(end);
    
  normA2_1(xind) = normA; % from EVD
    
  [normA2_2(xind), ind2(xind)] = normest(A, 1e-3);
  errA2_2(xind)  = abs((normA2_1(xind) - normA2_2(xind)))/normA2_1(xind);
     
  [normA2_3(xind), ind3(xind)] = max(gamavecQLP);
  errA2_3(xind)  = abs((normA2_1(xind) - normA2_3(xind)))/normA2_1(xind);
    
  [normA2_4(xind), ind4(xind)] = max(pnormdirectvecQLP);   
  errA2_4(xind)  = abs((normA2_1(xind) - normA2_4(xind)))/normA2_1(xind) ;

  [normA2_5(xind), ind5(xind)] = max(pnormvecQLP);  
  errA2_5(xind)  = abs((normA2_1(xind) - normA2_5(xind)))/normA2_1(xind); 
    
  normA2_6(xind) = norm( [alfavecQLP(1); betavecQLP] );
  errA2_6(xind)  = abs((normA2_6(xind) - normA2_1(xind)))/normA2_1(xind); 

  % Rasmus's

  normA2_7(xind) = norm( Tk, 1 );   
  errA2_7(xind)  = abs((normA2_7(xind) - normA2_1(xind)))/normA2_1(xind); 
    
  normA2_8(xind) = sqrt(norm(Tkbar'*Tkbar,1));
  errA2_8(xind)  = abs((normA2_8(xind) - normA2_1(xind)))/normA2_1(xind); 
    
  kk = min(k, 5);
  normA2_9(xind) = norm( diag(alfavecQLP(1:kk)) + diag(betavecQLP(1:kk-1),1) + diag(betavecQLP(1:kk-1),-1) );
  errA2_9(xind)  = abs((normA2_9(xind) - normA2_1(xind)))/normA2_1(xind); 
    
  kk = min(k, 20);
  normA2_10(xind) = norm( diag(alfavecQLP(1:kk)) + diag(betavecQLP(1:kk-1),1) + diag(betavecQLP(1:kk-1),-1) );
  errA2_10(xind)  = abs((normA2_10(xind) - normA2_1(xind)))/normA2_1(xind); 
    
  normA2_11(xind) = norm( Lk, 1);
  errA2_11(xind)  = abs((normA2_11(xind) - normA2_1(xind)))/normA2_1(xind); 
    
  % Chen and Demmel 2000
  [mA,nA]=size(A);
  normA2_12(xind) = max(colnorms2(A,mA,nA));
  errA2_12(xind)  = abs((normA2_12(xind) - normA2_1(xind)))/normA2_1(xind); 
    
  normAF_1(xind)  = norm(ss);
 
  normAF_2(xind)  = norm(Tk, 'fro');
  errAF_2(xind)   = abs((normAF_2(xind) - normAF_1(xind)))/normAF_1(xind);

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %% Print Estimates
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % header

  fprintf('\nID = %d,   n = %d,  shift = %10.3e,  MINRES_QLP itns = %10d', id, n, shift, itn2)
    
  fprintf('\nMethod :   1          2        (i)      3        (i)      4       (i)       5        (i)      6 ')
  fprintf('\n||A||_2: %10.1e %10.1e (%4d) %10.1e (%4d) %10.1e (%4d) %10.1e (%4d) %10.1e %10.1e %10.1e ', ...
      normA2_1(xind), normA2_2(xind), ind2(xind), normA2_3(xind), ind3(xind),...
      normA2_4(xind), ind4(xind), normA2_5(xind), ind5(xind), normA2_6(xind) )
  fprintf('\nError  :            %10.1e        %10.1e        %10.1e        %10.1e        %10.1e',...
      errA2_2(xind), errA2_3(xind), errA2_4(xind), errA2_5(xind), errA2_6(xind));
  fprintf('\nMethod :   1          8')
  fprintf('\n||A||_F: %10.1e %10.1e', normAF_1(xind), normAF_2(xind) )
  fprintf('\nError  :            %10.1e', errAF_2(xind))
  fprintf('\n')
end


%% Graphical results
options = {'Interpreter','latex'};
h = figure(2);
set(h,   'Position', [ 53          19        1023         897]);
h = subplot(2,1,1);
set(h,  'Position', [ 1.3000e-001  5.8384e-001  7.7500e-001  3.4116e-001]);
xn = 1:xind;
semilogy(xn, errA2_2SOL, 'b.:',...
         xn, errA2_4SOL, 'rs:',...
         xn, errA2_5SOL, 'c+:')
hl = legend('$| $ NORMEST $(A)  -\phantom{1} \|A\|_2  | / \|A\|_2$',   ...
    '$| \max \|p_i\|_2 - \phantom{1}\|A\|_2  | / \|A\|_2$', ...
    '$| \max \|T_k e_i\|_2 -\phantom{1} \|A\|_2  | / \|A\|_2$', 4);
set(hl, options{:});
%ht = title('$\|A\|_2$');
%set(ht, options{:});
set(h, 'XTick', [1 2 3 4 5 6 7 8 9 10 11 12]);

h  = subplot(2,1,2);
semilogy(xn, errAF_2SOL,'kd:')
hl = legend('$| \|T_k|\|_F - \phantom{1}|A\|_F  | / \|A\|_F$');
set(hl, options{:});
%set(hl, 'fontsize',8, 'Position', [6.8525e-001  6.2582e-001  2.2666e-001  2.7121e-001]);
%ht = title('$\|A\|_F$');
%set(ht, options{:});
set(h, 'XTick', [1 2 3 4 5 6 7 8 9 10 11 12]);
%% save files
print( gcf, '-depsc2', 'testminresQLPNormA8SOL') % save .eps
hgsave('testminresQLPNormA8SOL') % save .fig
save('testminresQLPNormA8SOL') % .mat


%% Graphical results
h = figure(3);
set(h,   'Position', [ 53          19        1023         897]);
h = subplot(2,1,1);
set(h,  'Position', [ 1.3000e-001  5.8384e-001  7.7500e-001  3.4116e-001]);
xn = 1:xind;
semilogy(xn, min(errA2_5, errA2_3), 'rs:',...
         xn, errA2_7, 'bd:',...
         xn, errA2_8, 'g*:',...
         xn, errA2_9, 'rx-.',...
         xn, max(errA2_10,eps),'ro-.',...
         xn, errA2_2, 'g.--',...
         xn, errA2_12,'ks-')
hl = legend( '$|  \max_i \{\|T_i e_i\|, |\gamma_i| \}-  \phantom{1}\|A\|  | / \|A\|$',...
             '$| \| T_k \|_1 -  \phantom{1}\|A\| | / \|A\| $',...
             '$\left\vert \sqrt{\| \underline{T_k} ^T \underline{T_k}\|_1 } -  \phantom{1}\|A\| \right\vert / \|A\|$ ',...
             '$| \phantom{1} \sigma_1(T_5) - \phantom{1} \|A\| | / \|A\|$',...
             '$| \phantom{1} \sigma_1(T_{20}) -  \phantom{1}\|A\|| / \|A\|$',...
             '$|$ NORMEST $(A) - \phantom{1} \|A\|| / \|A\|$',...
             'Chen and Demmel',...
             1);
set(hl, options{:});
set(hl, 'fontsize', 8, 'Position', [6.8525e-001  6.2582e-001  2.2666e-001  2.7121e-001]);
%ht = title('$\|A\|_2$');
%set(ht, options{:});
  
set(h, 'YLim',  [1e-16 1e0]);
set(h, 'YTick', [1e-15 1e-10 1e-5 1e0]);
set(h, 'XLim',  [1 12]);
set(h, 'XTick', [1 2 3 4 5 6 7 8 9 10 11 12]);
          
h  = subplot(2,1,2);
semilogy(xn, errAF_2,'kd:');
hl = legend('$| \|T_k|\|_F -  \phantom{1}\|A\|_F  | / \|A\|_F$');
set(hl,  options{:});
%ht = title('$\|A\|_F$');
%set(ht, options{:});
diary off
set(h, 'XTick', [1 2 3 4 5 6 7 8 9 10 11 12]);

%% save files
print( gcf, '-depsc2', 'testminresQLPNormA8QLP') % save .eps
hgsave('testminresQLPNormA8QLP') % save .fig
save('testminresQLPNormA8QLP') % .mat

keyboard


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% private function ConstructProblem
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [A,b,shift,n,id,itnlim,isdiag] = ConstructProblem(probnum);

isdiag   = 0;

switch probnum

  case 1 % small example n = 25  % almost compatible

    load('Davis1177.mat');
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n;
    show     = true;
    shift    = 0;
    xnormtol = 1e12;
    shift0   = 4;%-2;
    shiftn   = 4.001; %5.5;
    shifth   = 0;
    mu       = 10;
    smallr   = 1e-5*ones(n,1);
    b        = (A-shift*speye(n))*rand(n,1)  ; %  compatible 
     
  case 2 % small example n = 25

    load('Davis1177.mat');
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n*2;
    show     = true;
    smallr   = 1e-4*rand(n,1);
    b        = (A-shift*speye(n))*rand(n,1) + smallr; % almost compatible
    rtol     = 1e-14;
    shift    = 0;% eigenvalue
    shift0   = 4;%-2;
    shiftn   = 4.001; %5.5;
    shifth   = 0;
       
  case 3 % small example n = 25

    load('Davis1177.mat');
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n*2;
    show     = true;
    b        = rand(n,1); % incompatible
    rtol     = 1e-11;
    shift    = 0;% eigenvalue
    shift0   = 4;%-2;
    shiftn   = 4.001; %5.5;
    shifth   = 0;

  case 4 % small example n = 25

    load('Davis1177.mat');
    A        = Problem.A;
    [A, D]   = diagscal5(A);
    isdiag   = 1;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n*2;
    show     = true;
    b        = rand(n,1); % incompatible
    rtol     = 1e-11;
    shift    = 0;% eigenvalue
    shift0   = 4;%-2;
    shiftn   = 4.001; %5.5;
    shifth   = 0;

  %=========================================================================
  case 5 % n = 1138, SPD matrix. CG best but all methods exhibits slow convergence!!!

    load('Davis1.mat'); 
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n*2;
    rtol     = 1e-11;
    show     = false;
    shift    = 0;
   %xnormtol = 1e12;
    shifth   = 0;
    b        = (A-shift*speye(n))*rand(n,1); % compatible 
   %condestA = condest(A-shift*speye(n))
  
  case 6 % n = 1138,  

    load('Davis1.mat'); 
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n * 2;
    show     = false;
    shift    = 0.8957508633415;
   %xnormtol = 1e12;
    shift0   = 59;
    shiftn   = 10;
    shifth   = 0;%0.0001
    smallr   = 1e-5*ones(n,1);
    b        = (A-shift*speye(n))*rand(n,1) + smallr; % almost compatible 
   %condestA = condest(A-shift*speye(n))

  case 7 % n = 1138,  

    load('Davis1.mat'); 
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n;
    show     = false;
    shift    = 0.8957508633415;
   %xnormtol = 1e12;
    shift0   = 59;
    shiftn   = 10;
    shifth   = 0;%0.0001
    smallr   = 1e-5*ones(n,1);
    b        = rand(n,1); % incompatible 
  
  case 8 % n = 1138,  

    load('Davis1.mat'); 
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    [A,D]    = diagscal5(A);
    isdiag   = 1;
    itnlim   = n;
    show     = false;
    shift    = 0.8957508633415;
   %xnormtol = 1e12;
    shift0   = 59;
    shiftn   = 10;
    shifth   = 0;%0.0001
    smallr   = 1e-5*ones(n,1);
    b        = rand(n,1); % incompatible 

  %=======================================================================     
  case 9 % n = 3002, symmetric indefinite and "nonsingular"
         % with s(1001:1002)= -3.7221e-015 and -1.6815e-015. Set mu = 20.
         % no rhs provided.
         %%%%% Good Example !!!! %%%%%%
        
    load('Davis1239.mat');  % no rhs provided.
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = 1000;
    show     = false;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0;%.0001
    mu       = 20;
    b        = (A-shift*speye(n))*ones(n,1); % compatible 
   %condestA = condest(A-shift*speye(n))
       
  case 10 % n = 3002, symmetric indefinite and "nonsingular"
          % with s(1001:1002)= -3.7221e-015 and -1.6815e-015. Set mu = 20.
          % no rhs provided.
          %%%%% Good Example !!!! %%%%%%

    load('Davis1239.mat');  % no rhs provided.
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = 1000; % about 1000 nonzero distinct eigenvalues
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0;%.0001
    mu       = 20;
    smallr   = 1e-10*ones(n,1);
    b        = (A-shift*speye(n))*ones(n,1) + smallr; % almost compatible  
   %condestA = condest(A-shift*speye(n))
       
  case 11 % n = 3002, symmetric indefinite and "nonsingular"
          % with s(1001:1002)= -3.7221e-015 and -1.6815e-015
          % no rhs provided.
          %%%%% Good Example !!!! %%%%%%
          % Why SYMMLQ flag message says rnorm converged and log showed so
          % but then rnorm returned is not small at all?
        
    load('Davis1239.mat');  % no rhs provided.
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = 1000;
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3; 
    shifth   = 0;%.0001
    mu       = 20;
   %smallr   = 1e-5*ones(n,1);
    b        = ones(n,1); % incompatible  
       
  case 12 % n = 3002, symmetric indefinite and "nonsingular"
          % with s(1001:1002)= -3.7221e-015 and -1.6815e-015
          % no rhs provided.
          %%%%% Good Example !!!! %%%%%%
          % Why SYMMLQ flag message says rnorm converged and log showed so
          % but then rnorm returned is not small at all?
        
    load('Davis1239.mat');  % no rhs provided.
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    [A,D]    = diagscal5(A);
    isdiag   = 1;
    itnlim   = 1000;
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0;%.0001
    mu       = 20;
   %smallr   = 1e-5*ones(n,1);
    b        = ones(n,1); % incompatible  
       
    %=======================================================================     

  case 13 % n = 782, all negative and very small eigenvalues, ||A|| ~= 1e-5
          % % no rhs provided.
          % Feed in -A so that CG can work!
          % This example makes us change in minresQLP from
          %        if abs(gamma) > 1/maxxnorm
          %   to:  if abs(gamma) > Anorm/maxxnorm

    load('Davis297.mat');  % no rhs provided.
    A        = -Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n;
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0 ;
    rtol     = eps;
    b        = (A-shift*speye(n)) * ones(n,1); % compatible       
      
  case 14 % n = 782, all negative and very small eigenvalues, ||A|| ~= 1e-5
          % % no rhs provided.
          % Feed in -A so that CG can work!
          % This example makes us change in minresQLP from
          %        if abs(gamma) > 1/maxxnorm
          %   to:  if abs(gamma) > Anorm/maxxnorm

    load('Davis297.mat');  % no rhs provided.
    A        = -Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n;
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0 ;
    rtol     = eps;
    smallr   = 1e-4*ones(n,1);
    b        = (A-shift*speye(n))*ones(n,1) + smallr; % almost compatible 
   
  case 15 % n = 782, all negative and very small eigenvalues, ||A|| ~= 1e-5
          % % no rhs provided.
          % Feed in -A so that CG can work!
          % This example makes us change in minresQLP from
          %        if abs(gamma) > 1/maxxnorm
          %   to:  if abs(gamma) > Anorm/maxxnorm

    load('Davis297.mat');  % no rhs provided.
    A        = -Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n;
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0 ;
    rtol     = 1e-8;
    b        = 1e-3*ones(n,1); % INcompatible   

  case 16 % n = 782, all negative and very small eigenvalues, ||A|| ~= 1e-5
          % % no rhs provided.
          % Feed in -A so that CG can work!
          % This example makes us change in minresQLP from
          %        if abs(gamma) > 1/maxxnorm
          %   to:  if abs(gamma) > Anorm/maxxnorm

    load('Davis297.mat');  % no rhs provided.
    A        = -Problem.A;
    [A,D]    = diagscal5(A);
    isdiag   = 1;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n;
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0 ;
    b        = 1e-3*ones(n,1); % INcompatible      
       
    %---------------------------------------------------------------------
 
  case 17 % n = 

    load('Davis358.mat');  % no rhs provided.
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n;
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0;
    b        = (A-shift*speye(n)) * ones(n,1); % compatible 
       
    %---------------------------------------------------------------------
 
  case 18 % n = 2003 % All eigenvalues +ve and very large, between 2.84e+002 and  3.11e+012.
          % Big ||A|| ~=  2 x 10^13 , MINRES- ||r_k|| level off at 10^5!
          % Too big! Not converged!!!

    load('Davis35.mat');  % no rhs provided.
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n;
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0;
    rtol     = 1e-8;
    b        = (A-shift*speye(n)) * ones(n,1); % compatible 

  case 19
    
    % n = 2003   % All eigenvalues +ve and very large, between 2.84e+002 and  3.11e+012.
                 % Big ||A|| ~=  2 x 10^13 , MINRES- ||r_k|| level off at 10^5!
                 % Too big! Not converged!!! 
                 % Much better with diagonal Scaling. Postprocess solutions afterwards.

    load('Davis35.mat');  % no rhs provided.
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    itnlim   = n;
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0;
    rtol     = 1e-12;
    b        = (A-shift*speye(n)) * ones(n,1); % compatible 

  case 20 % n = 2003   % All eigenvalues +ve and very large, between 2.84e+002 and  3.11e+012.
          % Big ||A|| ~=  2 x 10^13 , MINRES- ||r_k|| level off at 10^5!
	  % Too big! Not converged!!! 
	  % Much better with diagonal Scaling. Postprocess solutions afterwards.
 
    load('Davis35.mat');  % no rhs provided.
    A        = Problem.A;
    n        = length(A);
    id       = Problem.id;
    title    = Problem.title;
    [A, D]   = diagscal5(A);
    isdiag   = 1;
    itnlim   = n;
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0;
    rtol     = 1e-12;
    b        = (A-shift*speye(n)) * ones(n,1); % compatible 
 
    %---------------------------------------------------------------------
 
  case 21 % n = Hermitian. Problem: ||A||_F is too big an estimate from MINRES solvers.
          % ||r|| direct from minresQLP mismatch recurrent ||r||.

    [A,rows,cols,entries,rep,field,symm] = mmread('mhd1280b.mtx');
    n        = length(A);
    id       = -1;
    title    = 'Matrix Market, MHD1280B: Alfven Spectra in Magnetohydrodynamics';
    itnlim   = n;
    show     = true;
    shift    = 0;
    shift0   = .1;
    shiftn   = 3 ;
    shifth   = 0;
    rtol     = 1e-20;
    b        = 0.01 * ( A-shift*speye(n)) * ( ones(n,1) + sqrt(-1) * ones(n,1)); % compatible 

end
